\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{diunivrreport}[2004/04/15 v 1.2 DIUNIVR Research Report]

\RequirePackage{ifthen,graphicx}

% An option for printing cropmarks on the report.
\newboolean{cropmarks}
\DeclareOption{cropmarks}{\setboolean{cropmarks}{true}}

% An option for printing cardboard cover pages.
\newboolean{cover}
\DeclareOption{cover}{\setboolean{cover}{true}}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% A DIUNIVR report is a kind of article.                    %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{article}}

\ProcessOptions

\LoadClass[twoside,a4paper,titlepage]{article}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DIUNIVR reports have some fields that articles dont, namly:       %
%   diunivrnumber: The number of the DIUNIVR report.                %
%   isbn:   The ISBN number of the report.              %
%   group:  The DIUNIVR research group that produced the report.    %
%   keywords:   Some keywords the describe the report.          %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Posenato
\def\email#1{{\tt#1}}

\newcommand{\@diunivrnumber}{?}
\newcommand{\diunivrnumber}[1]{\renewcommand{\@diunivrnumber}{#1}}

\newcommand{\@isbn}{?}
\newcommand{\isbn}[1]{\renewcommand{\@isbn}{#1}}

\newcommand{\@group}{}
\newcommand{\group}[1]{%
  \renewcommand{\@group}{%
    \begin{center}%
%      \textbf{Laboratory}\\
      #1
    \end{center}%
  }%
}

\newcommand{\@keywords}{}
\newcommand{\keywords}[1]{%
  \renewcommand{\@keywords}{%
    \vspace{2\baselineskip}
    \begin{raggedright}%
      \textbf{Keywords:} #1
    \end{raggedright}%
  }%
}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   isss:   The ISSN number of the series.              %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\newcommand{\@issn}{}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% The date in a DIUNIVR Report is just given as: Month YEAR.        %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\renewcommand{\today}{%
  \ifcase\month\or
    January\or
    February\or
    March\or
    April\or
    May\or
    June\or
    July\or
    August\or
    September\or
    October\or
    November\or
    December\fi\
  \number\year
}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% The authors of a DIUNIVR Report appear on seperate lines.     %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\renewcommand{\and}{\\}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% The thanks command is used to give an author's address.       %
% It behaves differently on the cover page and on the title page.   %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\newboolean{showthanks}
\renewcommand{\thanks}[1]{%
  \ifthenelse{\boolean{showthanks}}{\\
    {\addr@font
      \hspace{2.5em}%
      \begin{tabular}{@{}l@{}}%
    #1
      \end{tabular}%
    }%
  }{}%
}

% Set up the margins _after_ the paper size has been selected by whatever
% style files the user has.

\newlength{\top@text}
\newlength{\top@head}
\newlength{\oleft@text}
\newlength{\eleft@text}
\newlength{\titleI@voffset}
\newlength{\titleI@hoffset}
\newlength{\titleII@voffset}
\newlength{\titleII@hoffset}
\newlength{\back@voffset}
\newlength{\back@hoffset}
\newlength{\crop@voffset}
\newlength{\crop@ooffset}
\newlength{\crop@eoffset}

\AtBeginDocument{
  % The top of the text on each page starts at this height.
  \setlength{\top@text}{1in}
  \addtolength{\top@text}{\baselineskip}
  \addtolength{\top@text}{\topskip}
  \addtolength{\top@text}{\headsep}
  \addtolength{\top@text}{\headheight}
  \addtolength{\top@text}{\topmargin}
  %
  % The top of the header on each page starts at this height.
  \setlength{\top@head}{1in}
  \addtolength{\top@head}{\topmargin}
  \addtolength{\top@head}{\baselineskip}
  %
  % The left of the text of odd pages starts at this width.
  \setlength{\oleft@text}{1in}
  \addtolength{\oleft@text}{\oddsidemargin}
  %
  % The left of the text of even pages starts at this width.
  \setlength{\eleft@text}{1in}
  \addtolength{\eleft@text}{\evensidemargin}
  %
  % The first title should start 90mm down from the top of the page.
  \setlength{\titleI@voffset}{90mm}
  \addtolength{\titleI@voffset}{-\top@text}
  %
  % The first title should start 40mm in from the left-hand side of the page
  \setlength{\titleI@hoffset}{40mm}
  \addtolength{\titleI@hoffset}{-\oleft@text}
  %
  % The second title should start 60mm down from the top of the page.
  \setlength{\titleII@voffset}{60mm}
  \addtolength{\titleII@voffset}{-\top@text}
  %
  % The second title should start 55mm in from the left-hand side of the page
  \setlength{\titleII@hoffset}{55mm}
  \addtolength{\titleII@hoffset}{-\oleft@text}
  %
  % The back page should start 165mm down from the top of the page.
  \setlength{\back@voffset}{165mm}
  \addtolength{\back@voffset}{-\top@text}
  %
  % The back page should start 30mm in from the left-hand side of the page
  \setlength{\back@hoffset}{30mm}
  \addtolength{\back@hoffset}{-\eleft@text}
  %
  % The crop marks should start 22.5mm down from the top of the page.
  \setlength{\crop@voffset}{22.5mm}
  \addtolength{\crop@voffset}{-\top@head}
  %
  % The crop marks should start 17mm in from the left-hand side of the page
  \setlength{\crop@ooffset}{17mm}
  \addtolength{\crop@ooffset}{-\oleft@text}
  \setlength{\crop@eoffset}{17mm}
  \addtolength{\crop@eoffset}{-\eleft@text}
}


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DIUNIVR report need crop marks when going off to the printers.        %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\newcommand{\crop@marks}[2]{%
  \vbox to 0pt{
    \vspace*{#2}
    \vbox to 0pt{
      \vss
      \hbox to 0pt{%
    \hspace{#1}%
    \hbox to 0pt{%
      \hss
      \rule{5mm}{0.1mm}%
      \hspace{2.9mm}%
      \rule[3mm]{0.1mm}{5mm}%
    }%
    \hspace{176mm}%
    \hbox to 0pt{%
      \rule[3mm]{0.1mm}{5mm}%
      \hspace{2.9mm}%
      \rule{5mm}{0.1mm}%
      \hss
    }%
    \hss
      }
    }
    \vspace*{252mm}
    \vbox to 0pt{
      \hbox to 0pt{%
    \hspace{#1}%
    \hbox to 0pt{%
      \hss
      \rule[7.9mm]{5mm}{0.1mm}%
      \hspace{2.9mm}%
      \rule{0.1mm}{5mm}%
    }%
    \hspace{176mm}%
    \hbox to 0pt{%
      \rule{0.1mm}{5mm}%
      \hspace{2.9mm}%
      \rule[7.9mm]{5mm}{0.1mm}%
      \hss
    }%
    \hss
      }
      \vss
    }
    \vss
  }%
}

\ifthenelse{\boolean{cropmarks}}{
  \let\old@plain=\ps@plain
  \renewcommand{\ps@plain}{%
    \old@plain
    \renewcommand{\@oddhead}{\crop@marks{\crop@ooffset}{\crop@voffset}\hfil}
    \renewcommand{\@evenhead}{\crop@marks{\crop@eoffset}{\crop@voffset}\hfil}
  }

  \let\old@empty=\ps@empty
  \renewcommand{\ps@empty}{%
    \old@empty
    \renewcommand{\@oddhead}{\crop@marks{\crop@ooffset}{\crop@voffset}\hfil}
    \renewcommand{\@evenhead}{\crop@marks{\crop@eoffset}{\crop@voffset}\hfil}
  }
}{}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DIUNIVR report titles look a bit different though.            %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


% The font for name of Department
\newcommand{\depname@font}{%
  \fontfamily{phv}%
  \fontseries{b}%
  \fontshape{n}%
  \selectfont\huge}

% The font for the title
\newcommand{\title@font}{%
  \fontfamily{phv}%
  \fontseries{b}%
  \fontshape{n}%
  \selectfont\Huge}

% The font for the author
\newcommand{\author@font}{%
  \fontfamily{phv}%
  \fontseries{b}%
  \fontshape{n}%
  \fontsize{20.74}{24}%
  \selectfont}

% The font for information on the cover
\newcommand{\cinfo@font}{%
  \fontfamily{phv}%
  \fontseries{b}%
  \fontshape{n}%
  \fontsize{17.28}{36}%
  \selectfont}

% The font for the information on the back
\newcommand{\back@font}{%
  \fontseries{b}%
  \fontshape{n}%
  \fontsize{11}{12}%
  \selectfont
  \rmfamily}

% The font for the information on the institutions
\newcommand{\inst@font}{%
  \fontseries{phv}%
  \fontshape{n}%
  \fontsize{9}{10}%
  \selectfont}

% The font for information on the title page
\newcommand{\tinfo@font}{%
  \fontseries{phv}%
  \fontshape{n}%
  \fontsize{12}{14}%
  \selectfont}

% The font for addresses
\newcommand{\addr@font}{%
  \fontseries{m}%
  \fontshape{n}%
  \fontsize{12}{14}%
  \selectfont
  \rmfamily}

% The font for URLs
\newcommand{\url@font}{%
  \fontseries{m}%
  \fontshape{n}%
  \fontsize{10}{12}%
  \selectfont
  \sffamily}

% This is the command that actually makes the title.
\renewcommand{\maketitle}{%
  \pagestyle{empty}%
  \ifthenelse{\boolean{cover}}{%
    \vspace*{\titleI@voffset}%
    \noindent
    \hspace*{\titleI@hoffset}%
    \hbox to 0pt{
      \vbox to 0pt{ 
        \hbox{%
          \vbox to 40mm{
            \hbox to 0pt{%
              \hss
              \includegraphics[width=40mm]{diunivrlogo}%
              \hspace{1mm}%
            }
            \vfil
          }
          \vbox to 37mm{\depname@font
            \hbox{Dipartimento di Informatica}
            \hbox{Universit\`a degli Studi di Verona}
          }
        }%
        \hbox{%
          \vbox to 40mm{\author@font
            \hbox{Rapporto di ricerca}
            \hbox{Research report}
            \vspace{0.5cm}
          }\hspace{1cm}
          \vbox to 35mm{\author@font
            \hbox{\@diunivrnumber}
          }
        }
        \hbox{%
          \vbox to 300mm{
            \hbox{\parbox{140mm}{\raggedright\title@font\@title\\[30pt]}}
            \hbox{\author@font\begin{tabular}{@{}l@{}}\@author\end{tabular}}
            \vfil
          }%
        }
        \vss
      }
    }
    \cleardoublepage
  }{}%
  \setboolean{showthanks}{true}%
  \vspace*{\titleII@voffset}%
  \noindent
  \hspace*{\titleII@hoffset}%
  \hbox to 0pt{%
    \vbox to 0pt{ 
      \hbox{%
        \vbox to 42mm{
          \hbox to 20pt{%
            \hss
            \includegraphics[width=40mm]{diunivrlogo}%
            \hspace{1mm}%
          }
          \vfil
        }
        \vbox to 30mm{\depname@font
          \hbox{Dipartimento di Informatica}
          \hbox{Universit\`a degli Studi di Verona}
        }
      }%
      \hbox{%
        \vbox to 15mm {
          \hbox{
            \vbox{
              \author@font
              \hbox{Rapporto di ricerca}
              \hbox{Research report}
            }
            \hspace{1cm}
            \vbox to 10mm{
              \author@font
              \hbox{\@diunivrnumber}
            }
          }
        }
      }
      \hbox{
        \vbox to 20mm{
          \tinfo@font
          \hbox{\@date}
          \vfil
                                %\hbox{ISBN \@isbn}
                                %\hbox{ISSN \@issn}
        }
      }
      \hbox{%
        \vbox to 110mm{
          \hbox{\parbox{140mm}{\raggedright\title@font\@title\\[30pt]}}
          \hbox{\author@font\begin{tabular}{@{}l@{}}\@author\end{tabular}}
          \vfil
        }%
      }
      \hbox{%
        \vbox to 20mm{
          \hbox{\tinfo@font{Questo rapporto \`e disponibile su Web 
              all'indirizzo:}}
          \hbox{\tinfo@font{This report is available on the web at the address:}}
          \hbox{\url@font{http://www.di.univr.it/report}}
          \vfil
        }%
      }
      \vss
    }%
    \hss
  }%
  \ifthenelse{\boolean{@titlepage}}{
    \clearpage
  }{
    \cleardoublepage
  }
  \setcounter{page}{1}
  \pagestyle{plain}%
}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DIUNIVR abstracts (which are mandatory) appear before the `first' page.   %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\ifthenelse{\boolean{@titlepage}}{%
  \let\@ldabstract=\abstract
  \let\@ldendabstract=\endabstract
  \renewenvironment{abstract}{%
    \@ldabstract
    \setcounter{page}{0}%
  }{
    \par
    \@keywords
    \vfill
    \begin{center}
      \@group
    \end{center}
    \vfill
    \@ldendabstract
    \setcounter{page}{1}%
  }%
}{}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% DIUNIVR reports have a page at the end with some logos on it.     %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\AtEndDocument{%
  \clearpage
  \pagestyle{empty}%
  \ifthenelse{\boolean{cover}}{%
    \cleardoublepage
    \hbox{}
    \clearpage
  }{%
    \ifthenelse{\isodd{\value{page}}}{%
      \hbox{}
      \clearpage
    }{}%
  }%
  \vspace*{\back@voffset}%
  \noindent
  \hspace*{\back@hoffset}%
  \hbox to 0pt{%
    \vbox to 0mm{
      \hbox to 60pt{%
        \hss
        \includegraphics[width=28mm]{univrlogo}%
        \hspace{1mm}%
      }
      \vfil
    }
    \vbox to 0pt{
      {\back@font
        \hbox{University of Verona}
        \hbox{Department of Computer Science}
        \hbox{Strada Le Grazie, 15}
        \hbox{I-37134 Verona}
        \hbox{Italy}
      }
      \vspace{5pt}
      \hbox{\url@font http://www.di.univr.it}
    }
    \vbox to 0mm{
      \hbox to 80pt{%
        \hss
        \includegraphics[width=28mm]{diunivrlogo}%
        \hspace{1mm}%
      }
      \vfil
    }
  }
}
